/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.noise;

import com.moulberry.axiom.noise.NoiseInterface;

public class FBMNoise
implements NoiseInterface {
    private final NoiseInterface[] delegateNoise;
    private final float lacunarity;
    private final float gain;
    private final float startAmplitude;

    public FBMNoise(float lacunarity, float gain, NoiseInterface ... delegateNoise) {
        this.delegateNoise = delegateNoise;
        this.lacunarity = lacunarity;
        this.gain = gain;
        float bounds = 0.0f;
        float amplitude = 1.0f;
        for (int i = 0; i < this.delegateNoise.length; ++i) {
            bounds += amplitude;
            amplitude *= this.gain;
        }
        this.startAmplitude = 1.0f / bounds;
    }

    @Override
    public float evaluate(double x, double y) {
        float amplitude = this.startAmplitude;
        float result = 0.0f;
        for (NoiseInterface noise : this.delegateNoise) {
            result += amplitude * noise.evaluate(x, y);
            amplitude *= this.gain;
            x *= (double)this.lacunarity;
            y *= (double)this.lacunarity;
        }
        return result;
    }

    @Override
    public float evaluate(double x, double y, double z) {
        float amplitude = this.startAmplitude;
        float result = 0.0f;
        for (NoiseInterface noise : this.delegateNoise) {
            result += amplitude * noise.evaluate(x, y, z);
            amplitude *= this.gain;
            x *= (double)this.lacunarity;
            y *= (double)this.lacunarity;
            z *= (double)this.lacunarity;
        }
        return result;
    }
}

